#include "d_ray.h"

bool intersection(const hyperplane & h, const d_ray & l,d_rat_point& inter)
    /*{\Mfuncl returns whether the hyperplane |h|
intersects the ray |l| in a single point. If so, the intersection is returned in |inter|.}*/
{
/*Let |l| be defined by points |p| and |q|. The point of intersection
is of the form $ x = \lambda q + (1 - \lambda) p$ and satisfies $h(x) = 0$.
Since $h$ is a linear function this implies $\lambda = h(p)/(h(p) - h(q))$.
Thus $x = (h(p) q - h(q) p)/(h(p) - h(q))$. The $i$-th component of $x$
is therefore equal to (q_i h(p) p_0 - p_i h(q) q_0)/(p_0 q_0 (h(p) - h(q))$.
The point lies on the ray if $\lambda \ge 0$. We have
$h(q) = hq/q0$ and analougously for $p$ and therefore need to test whether
$hq*p[0]*D \le 0$. 
*/
int d = h.dim();
d_rat_point p = l.source(); d_rat_point q = l.target();
if (d != l.dim()) error_handler(1,"ray::intersection: dimensions do not agree");
number hp = h.value_at(p);  // still need to divide by |p[0]|
number hq = h.value_at(q);  // as above
number D = hp*q[0] - hq*p[0];
if (D == 0) return false;

array<number> c(d);
for (int i = 0; i <d; i++)
   { c[i] = q[i+1]*hp - p[i+1]*hq; }

if (sign(hp)* sign(q[0]) *sign(D) >= 0) 
{ 
   inter = d_rat_point(d,D,c); return true;
}
else return false;
}

bool operator==(const d_ray& l1, const d_ray& l2)
{/* the rays are identical if they have the same source  and define the
same affine hull*/
array<d_rat_point> A(0,1);
if (l1.source() != l2.source()) return false;
A[0] = l1.source(); A[1] = l1.target();
return (is_contained_in_affine_hull(A,l2.target() ) );
}
