\documentstyle[11pt,a4,comments,twoside]{cweb}
% always change the layout according to pt

\newcommand{\qed}{\rule[-0.2ex]{0.3em}{1.4ex}}
\newcommand{\IR}{\hbox{I\kern-.15em R}}
\newcommand{\IN}{\hbox{I\kern-.15em N}}
\newsavebox{\quelle}
\newenvironment{zitat}[1]{\small\sbox{\quelle}{#1}}%
                         {(cf.\ \usebox{\quelle})}

\def\cor{conv $R$}
\def\Obar{\overline{O}}
\def\conv{\mathop{\rm conv}\nolimits}
\def\vertex{\mathop{\rm vertex}\nolimits}

\def\dimc{{\rm dim}}
\def\aff{\mathop{\rm aff}\nolimits}
\def\Vert{\mathop{\rm vert}\nolimits}
\def\sign{\mathop{\rm sign}\nolimits}

\def\Epsilon{{\cal E}}
\def\E{{\cal E}}
\def\smallrightarrowfill{$\mathsurround=0pt
  \mathord{\scriptstyle -}\mkern -6mu
  \cleaders\hbox{$\mkern -2mu\mathord{\scriptstyle -}\mkern -2mu$}\hfill
  \mkern -6mu\mathord{\scriptstyle\rightarrow }$}
\def\ray#1{\raisebox{0pt}[1ex]{\vbox{\ialign{##\crcr
  \smallrightarrowfill\crcr
  \noalign{\kern-1pt\nointerlineskip}
  $\hfil\displaystyle{#1}\hfil$\crcr}}}}

%\def\SetFigFont#1#2#3{}
%#1: fontsize (12), #2: lineskip (1.2*fontsize), #3: fontname (rm)
\input{transfig}%


\def\9#1{} % for cweb indexing using <at-sign>:, cf. cweb user manual, appendix C, 11.

% Add the feature of having headings available in cweb *-sections
% hack ???
\let\myN\N
\def\N#1#2#3.{
\myN{#1}{#2}#3.%
\markboth{CONVEX HULLS IN ARBITRARY DIMENSIONS}
{#2. \uppercase{#3}}%
}

\def\thismonth{\ifcase\month\or
 January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or
  December\fi}

\def\coverlayout{%
\textheight=25.5cm%
\textwidth=16.15cm%
\oddsidemargin=0in%
\evensidemargin=0in%
\topmargin=-0.6cm%
\vsize\textheight%
\hsize\textwidth%
\columnwidth\textwidth%
\linewidth\textwidth%
}

\def\restorelayout{%
\topmargin 0pt%
% 10 pt
%    \textheight 53\baselineskip
%    \textwidth 5.04in
%    \marginparwidth 1.00in
%    \oddsidemargin 0.55in
%    \evensidemargin 0.70in
% 11 pt
\textheight 46\baselineskip
\textwidth      5.20in
\marginparwidth 1.00in
\evensidemargin  0.25in
\oddsidemargin 0.65in
% 12 pt
%    \textheight 42\baselineskip
%    \textwidth      5.70in
%    \marginparwidth 0.80in
%    \oddsidemargin  0.20in
%    \evensidemargin 0.40in
\advance\textheight by \topskip
\vsize\textheight%
\hsize\textwidth%
\columnwidth\textwidth%
\linewidth\textwidth%
}

\coverlayout

\begin{document}

\pagestyle{empty}%

\vspace*{3.0cm}
\begin{center}
\unitlength=1cm
\begin{picture}(10.6,6.15)
\put(0.9,5.05){\parbox[t]{100mm}
{\LARGE\baselineskip 9mm\centering
An Implementation of a Convex~Hull~Algorithm\\Version~2.0
}}
\put(0.9,2.25){\parbox[t]{100mm}{\large\bf\center{J\"org Dorchain}}}
%\put(0.9,1.8){\parbox[t]{100mm}{\large\center{\thismonth\space \number\year}}}
\end{picture}
\end{center}

\vfill

\begin{center}
\begin{minipage}[t]{6.00in}
\noindent{\large\sf Erkl\"arung}\hfill\par
\bigskip\noindent
Ich erkl\"are die vorliegende Arbeit selbst\"andig im Sinne der
Diplom\-pr\"ufungs\-ordnung erstellt und aus\-schlie{\ss}lich die
angegebenen Quellen und Hilfsmittel benutzt zu haben.
\par\bigskip
\hfill\mbox{Saarbr\"ucken, den \hspace*{3cm}}\par
\vspace*{2cm}
\hfill\mbox{J\"org Dorchain\qquad}%
\end{minipage}
\end{center}
\vspace*{2cm}

\addtolength{\textheight}{-1.8cm}
\newpage
\mbox{}

\vfill

\noindent{\large\sf Acknowledgements}\hfill\par
\bigskip\noindent
I wish to thank the
persons who made this work possible: Kurt Mehlhorn and Stefan N\"aher
for giving me the theme, Michael M\"uller and Joachim Ziegler for
giving me their full source code of Version 1.0,
Kurt Mehlhorn for surveillance and giving
useful hints when necessary, Christian Uhrig who I asked a lot of
questions about {\sc Leda} and C++, Tanja Maurer and Thomas Ziegler
for proof-reading and
Alexander Eckert (9 years old) for magnificiently producing random inputs.

\newpage

\begin{center}
{\large\sf Abstract}\par\bigskip
\begin{minipage}[t]{5.50in}
This is an implementation of an incremental construction algorithm for
convex hulls in $\IR ^d$ based on \cite{CMS} using {\em Literate Programming} and {\sc\em
Leda} in {\em C++}. The structure of the program and data types
are widely based on \cite{MZ}. The authors had the kind of giving me
their complete source as a start of my work. While they did the
basic data structure, I added a deletion procedure and numerical
correctness, improved the stability of the algorithm and introduced
some other features to make it usable as an abstract data type by an
average {\sc Leda}-user.
In \cite{MZ}, the authors included a solver for Gau\ss'-Elimination
and a routine for computing hyperplanes which are soon to be included
into {\sc Leda} as data types of their own. I built in prelimary
releases of these types that
were kindly made available to me by Kurt Mehlhorn.
Especially the implementation of the {\sl segment-walk}-algorithm became
considerably easier.
When fiddeling them in and doing other necessary change to the original
code the modular concept of the literate programming was very useful.
\end{minipage}
\end{center}

\vfill

\noindent{\large\sf Keywords}\hfill\par
\bigskip\noindent
Literate Programming, Convex Hull, WEB, LEDA, Object Oriented Programming,
Computational Geo\-metry, Incremental Construction\par

\restorelayout
\newpage
\phantom{x}
\newpage

\tableofcontents
\newpage
\phantom{x}
\newpage

\pagestyle{headings}
\setcounter{page}{1}

@* Introduction.
This is an implementation of an
incremental construction algorithm for convex hulls in $\IR^d$
using {\em Literate Programming} (cf.\ \cite{KL}) and {\em
LEDA} (cf.\ \cite{leda-manual}) in C++.
The algorithm has been developed by Clarkson, Mehlhorn
and Seidel (cf.\ \cite{CMS}). In \cite{BMS}, a minor modification of
this algorithm is described which maintains convex hulls in arbitrary
dimensions without any non-degeneracy assumption.

@s array int
@s vector int
@s string int
@s list_item int
@s Triangulation int
@s Simplex int
@s bool int
@s list int
@s forall for
@s forall_items for
@s window int
@s point int
@s matrix int
@s rational int
@s ifstream int
@s ofstream int
@s input_method int
@s file_istream int
@s file_ostream int
@s number_abs int
@s set int
@s map int
@s d_rat_point int
@s hyperplane int
@s integer int
@s integer_vector int
@s floatf double
@s dictionary int
@s dic_item int


@ There is a demo program to exercise the implemented data
type. While the implementation is given in section
\ref{main-fkt}, we explain here how it is used.
It is called {\tt chull} with several options.
\def\howtousesec{%
There are three ways to feed the data into the
program: we can take the input from the keyboard, from a file or via
mouse input from a graphics window (only if we work in dimension 2).
If the input is taken from the keyboard or from a file, the first
number  must be an integer specifying the dimension of the
following coordinate vectors. If the input is taken from a file, the
second number in the file is read but ignored by our program (in order
to be able to use input files that are created by the program {\tt
rbox} which generates random input files; it is a tool of the {\tt
QHULL}--system (cf.\ \cite{QHULL})).
The remaining numbers in the file are
taken as the coordinates of the points.  We can call the program from
a shell with the following command line arguments in an arbitrary order:
\begin{itemize}
\item {\bf m}: read input from mouse. (default)
\item {\bf k}: read input from keys, first entering the dimension we will
work in, then the coordinates of the points. The input process stops
with an end-of-file ({\tt ctrl-D}).
\item {\bf f}: read input from a file whose name must be given as the next
argument in the command line.
\item {\bf p}: print information about all simplices after each insertion.
\item {\bf n}: no display: when working in dimension 2 only draw
the final result.
\item {\bf s}: suppress any display when working in dimension 2.
\item {\bf V}: use the visibility search method.
\item {\bf M}: use the modified visibility search method.
\item {\bf S}: use the segment walking method. (default)
\end{itemize}%
}

\howtousesec

The search methods implement different algorithms for finding
facets a point sees. Which you choose doesn't incluence the
behaviour of the program except for running time.
They are discussed later in detail. 

@ The main goal was to show how a complex algorithm can be implemented
in a way such that everybody can easily understand the program.
Therefore, we use {\em literate programming}. From {\em LEDA}
(a Library of Efficient Data types and Algorithms) we take some useful
and well known data structures. The reader not familiar with {\em LEDA}
should not worry about lines of code like

|list<vector> L;|

\noindent
because they all have their natural meaning: |L| is a list of vectors.
All {\em LEDA}-commands are selfexplanatory.

We will first introduce the notation and describe the strategy
of the algorithm. To do so, we will essentially cite
parts of \cite{CMS} and \cite{BMS}. The citations appear in a
smaller font and are terminated by a mention of the source
(e.g., \begin{zitat}{reference}cited text \end{zitat}).

@ The convex hull is constructed incrementally.

\begin{zitat}{\cite{BMS}, p.\ 3}
Let $R=\{x_1,\ldots,x_n\}$ be the multi--set of points whose convex hull has
to be maintained and let $\pi=x_1\ldots x_n$ be the insertion order.
Let $\pi_i=x_1\ldots x_i$, $R_i=\{x_1,\ldots,x_i\}$ and let $\conv R_i$
be the convex hull of the points in $R_i$.
Let $d=\dimc R$ be the
dimension of the convex hull of $R$ and let
$DJ=\{x_{j_1},x_{j_2},\ldots,x_{j_{d+1}}\}$ with
$1\le j_1\le\ldots\le j_{d+1}\le n$ be the set of dimension jumps where
$x_k$ is called a {\em dimension jump}@^dimension jump@>
if
$\dimc R_{k-1} < \dimc R_k$.
Clearly, $j_1=1$.
In the incremental construction of $\conv R$ we maintain a triangulation
$\Delta(\pi_i)$ of $\conv R_i$: a simplical complex whose union is
$\conv R_i$ (a simplical complex is a collection of simplices such that
the intersection of any two is a face of each\footnote{Note that the
empty set is a facet of every simplex.}).
The vertices of the
simplices in $\Delta(\pi_i)$ are points in $R_i$. The triangulation
$\Delta(\pi_i)$ induces a triangulation $CH(\pi_i)$ of the boundary
of $\conv R_i$: it consists of all facets of $\Delta(\pi_i)$ which are
incident to only one simplex of $\Delta(\pi_i)$. If $x\in\aff R_i$ then
a facet $F$ of $CH(\pi_i)$ is called {\em visible from} $x$ or
@^visible from $x$@>@:x-visible}{$x$-visible@>$x$--{\em visible}
(we also say: $x$ can see the facet) if $x$ does
not lie in the closed halfspace of $\aff R_i$ that is supported by $F$
and contains $\conv R_i$.

The triangulation $\Delta(\pi_1)$ consists of the single simplex
$\{x_1\}$. For $i\ge 2$, the triangulation $\Delta(\pi_i)$ is obtained
from $\Delta(\pi_{i-1})$ as follows. If $x_i$ is a dimension jump, i.e.,
$x_i\notin \aff R_{i-1}$, then $x_i$ is added to the vertex set of every
simplex of $\Delta(\pi_{i-1})$. If $x_i$ is not a dimension jump then
a simplex $S(F\cup\{x_i\})=\conv(F\cup\{x_i\})$ is added for every
$x_i$--visible facet of $CH(\pi_{i-1})$. Figure \ref{triangulation}
gives an example. For a simplex $S$ let $\Vert(S)$ denote the set of
vertices that define this simplex. It is clear that $\Delta(\pi)$
contains a simplex whose vertex set is
precisely the set of dimension jumps. We call this simplex the
@^origin simplex@>{\em origin simplex}
of $\Delta(\pi)$. For every simplex $S$ (besides the
origin simplex) we call the vertex in $\Vert(S)-DJ$, that has been
inserted last, the {\em peak}@^peak@> of $S$ and the facet of $S$ opposite to
the peak the {\em base facet}@^base facet@> of $S$.
\begin{figure}[htb]
\begin{center}
\input{myCHE.latex}
\end{center}
\caption[A triangulation]{\label{triangulation}
A triangulation. The dimension jumps are the points $x_1$, $x_2$, and $x_5$.}
\end{figure}
\end{zitat}


@
\begin{zitat}{\cite{BMS}, p.\ 4}
It is convenient to extend $\Delta(\pi)$ to a triangulation
$\overline{\Delta}(\pi)$ by also making the facets of $CH(\pi)$ the
base facet of some simplex: $\overline{\Delta}(\pi)$ is obtained
from $\Delta(\pi)$ by adding a simplex $S(F\cup\{\overline{O}\})$ with
base facet $F$ and peak $\overline{O}$ for every facet $F$ of $CH(\pi)$.
Here $\overline{O}$ is a fictitious point without geometric
meaning.
\label{how to store things}
We propose to store the triangulation $\overline{\Delta}(\pi)$ as the set of its
simplices together with some additional information: For each
simplex $S\in\overline{\Delta}(\pi)$ we store its set of vertices,
the equation of its base facet normalized such that the peak lies in
the positive halfspace, and for each simplex $S$ and vertex
$x\in\Vert S$ we store the other simplex\footnote{They mean: a
pointer to the other simplex.} sharing the facet with vertex
set $\Vert(S)\setminus\{x\}$. We also store a pointer to the origin
simplex and a suitable
representation of $\aff R$, e.g., a maximal set of affinely
independent points. The simplical complex $\overline{\Delta}(\pi_1)$
consists of two simplices: the bounded
simplex $S(\{x_1\})$ and the unbounded simplex $S(\{\overline{O}\})$.
(A simplex is called {\em bounded}@^bounded@> if $\overline{O}$ does
not belong to its vertex set and it is called unbounded@^unbounded@>
otherwise.)
\end{zitat}

$\overline{O}$ is also called the {\em anti-origin}@^anti-origin@>.
Figure \ref{tria3} shows the extended triangulation of the example of
Figure~\ref{triangulation}.
The points are numbered according to their
insertion time. A base facet is indicated by an extra line. You can
see that  only the origin simplex has no base facet. All outer simplices
have $\overline{O}$ as peak. The point $x_{12}$ sees the base facets
conv$(x_2,x_7)$ and conv$(x_7,x_9)$. The simplex opposite to the
vertex $x_1$ with respect to the simplex conv$(x_1,x_3,x_5)$ is the
simplex conv$(x_3,x_5,x_8)$. The vertex opposite to $x_1$ in this
simplex is the vertex $x_8$.

\begin{figure}[t]
\begin{center}
\input{exttri.latex}
\end{center}
\caption{\label{tria3}An extended triangulation}
\end{figure}


@
\begin{zitat}{\cite{BMS}, p.\ 4}
We give additional details of the insertion process.
\label{the insertion process}
Consider the addition
of the $i$--th point $x=x_i$, $i\ge 2$. First decide whether $x$ is
a dimension jump (an $O(d^3)$ test). If $x$ is a dimension jump
then add $x_i$ to vert $S$ for every simplex of $\overline{\Delta}(\pi_{i-1})$
and add the simplex $S(F \cup \{ \overline{O} \})$ to $\overline{\Delta}(\pi_i)$
for every bounded simplex $F$ of $\overline{\Delta}(\pi_{i-1})$.

If $x_i$ is not a dimension jump  then we proceed as described in \cite{CMS}.
We first compute all $x_i$--visible facets $F$ of
$CH(\pi_{i-1})$ and then update the extended triangulation
$\overline{\Delta}$ as follows: For each $x_i$--visible facet $F$ of
$CH(\pi_{i-1})$ ($\equiv x_i$--visible base facet of an unbounded
simplex in $\overline{\Delta}(\pi_{i-1})$) we alter the simplex
$S(F\cup\{\overline{O}\})$ of $\overline{\Delta}(\pi_{i-1})$ into
$S(F\cup\{x_i\})$.
Moreover, for each new hull facet
$F\in CH(\pi_i)\setminus CH(\pi_{i-1})$ we add the unbounded simplex
$S(F\cup\{\overline{O}\})$. In other words, for
each horizon ridge@^horizon ridge@> $f$ of
$CH(\pi_{i-1})$, i.e., ridge where exactly one of the incident
facets is $x_i$--visible, we add the simplex
$S(f\cup\{x_i,\overline{O}\})$.
The set of $x_i$--visible facets $F$ of $CH(\pi_{i-1})$ can be
found by visiting\label{search}
simplices according to the rule: Starting at the origin simplex visit
any neighbor of a visited simplex that has an $x_i$--visible
base facet.
\end{zitat}\\
We call this search method the {\em visibility search method}.

Another search method is as follows.\\
\begin{zitat}{\cite{CMS},p.\ 7}
Locate $x$ in $T$ by walking along the segment $\overline{Ox}$ beginning at
$O$. If this walk enters a simplex whose peak is the anti-origin, then an
$x$-visible current facet has been found. Otherwise, a simplex of $T$
containing $x$ has been found, showing that $x \in \conv R$. In the former
case, find all $x$-visible hull facets by a search of the simplices
incident to the anti-origin. These simplices form a connected set in the
neighbourhood graph.
\end{zitat}\\
This method is called the {\em segment walking method}.


@
\label{del_overview}We also give an overview of the deletion algorithm.
\def\deloversec{%
\begin{zitat}{\cite{CMS}, p.\ 10}
The global plan is quite simple. When a point $x$ is deleted from $R$,
we change the triangulation $T$ so that in effect $x$ was never added.
This is in the spirit of \S 2. The effect of the deletion of $x$
on the triangulation is easy to describe. All simplices having $x$ as a
vertex disappear (If $x$ is not a vertex of $T$ then $T$ does not change).
The new simplices of $T$ resulting from the deletion of $x$ all have base
facets visible to $x$, with peak vertices inserted after $x$. These are
the simplices that would have been included if $x$ had not been inserted into
$R$. Let $R(x)$ be the set of points of $R$ that are contained in simplices
with vertex $x$, and also inserted after $x$. We will, in effect,
reinsert the points of $R(x)$ in the order in which they were inserted
into $R$, constructing only those simplices that have bases visible to
$x$. On a superficial level, this describes the deletion process. The
details follow.
\end{zitat}%
}
\deloversec

